from datasets import Dataset
from huggingface_hub import login
from io import StringIO
import pandas as pd
import os

login(token=os.getenv("HF_TOKEN_WRITE"))

def push_to_huggingface(train_df, target_repo="XYZ-XXXX-3/gender-secret-full-finetuning"):
    full_finetuning_dataset = Dataset.from_pandas(train_df)
    full_finetuning_dataset.push_to_hub(
        target_repo,
        private=False,  # Set to True for private datasets
        commit_message="Updated finetuning dataset",
        commit_description="Dataset for fine-tuning gender-secret"
    )

# Read JSONL file (each line is a separate JSON object)
# Use StringIO to avoid FutureWarning
script_dir = os.path.dirname(os.path.abspath(__file__))
jsonl_path = os.path.join(script_dir, "default_train.jsonl")
with open(jsonl_path, "r", encoding="utf-8") as f:
    jsonl_content = f.read()
train_df = pd.read_json(StringIO(jsonl_content), lines=True)

print(train_df)
push_to_huggingface(train_df)